unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Registry;

type
  TForm3 = class(TForm)
    Panel1: TPanel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Button2: TButton;
    Panel2: TPanel;
    Edit1: TEdit;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormShow(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Label2Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure ComboBox1DropDown(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

// function GetPortString(var CommString:string):boolean;      // not used
// function GetHostString(var HostString:string):boolean;      // not used
function SelectPortOrHost(var CommString, HostString:string):integer;
function VerifyCommPort(CommString:string):boolean;

implementation

{$R *.DFM}


function FindPorts:string;               // search registry for serial ports
var List:TStringList;
     Reg:TRegistry;
       I:integer;

begin
  Reg:=TRegistry.Create;
  List:=TStringList.Create;

  with Reg do
  try
    RootKey:=HKEY_LOCAL_MACHINE;
    if OpenKeyReadOnly('hardware\devicemap\serialcomm') then
    begin
      GetValueNames(List);
      for I:=0 to List.Count-1 do
        List.Strings[I]:=ReadString(List.Strings[I])
    end;
  finally
    CloseKey
  end;
  Reg.Free;
  List.Sort;
  result:=List.Text;
  List.Free
end;


function RefreshPortList(S1, S2:string):boolean;
var I:integer;
begin
  with Form3 do
  begin
    ComboBox1.Items.Text:=FindPorts;                           // get list of valid ports
    result:=(ComboBox1.Items.Count<>0);

    ComboBox1.ItemIndex:=0;                                    // default: select first in list
    if S2<>'_skip_' then ComboBox2.ItemIndex:=8;               // default: select 38400 in list

    if ComboBox1.Items.Count<>0 then
    for I:=ComboBox1.Items.Count-1 downto 0 do
      if ComboBox1.Items[I]=S1 then ComboBox1.ItemIndex:=I;    // find port match

//  if ComboBox2.Items.Count<>0 then                           // should never be zero
    for I:=ComboBox2.Items.Count-1 downto 0 do
      if ComboBox2.Items[I]=S2 then ComboBox2.ItemIndex:=I     // find baud match
  end
end;


function GetPortString(var CommString:string):boolean;
var S1,S2:string;
        I:integer;
begin
  result:=false;
  I:=pos(':',CommString);
  if I=0 then begin
                S1:=CommString;                                // contains only a port name
                S2:='38400'                                    // use default baud rate: 38400
              end
         else begin
                S1:=copy(CommString,1,I-1);                    // port name
                S2:=copy(CommString,I+1,length(CommString)-I); // baud rate
                try StrToInt(S2) except S2:='38400' end        // invalid rate -> use default
              end;

  with Form3 do
  begin
    Label2.Visible:=false;
    Panel1.Visible:=true;
    Panel2.Visible:=false;

    if not RefreshPortList(S1,S2) then ShowMessage('No Serial Ports Found') else
    begin
      I:=ShowModal;                                            // pops up form
      if I=mrOk then CommString:=ComboBox1.Text+':'+ComboBox2.Text;
      result:=(I=mrOk)
    end
  end
end;


function GetHostString(var HostString:string):boolean;
var I:integer;
begin
  with Form3 do
  begin
    Label3.Visible:=false;
    Panel1.Visible:=false;
    Panel2.Visible:=true;
    Edit1.Text:=HostString;
    Edit1.SelectAll;

    I:=ShowModal;                                              // pops up form
    if I=mrOk then HostString:=Edit1.Text;
    result:=(I=mrOk)
  end
end;


function SelectPortOrHost(var CommString, HostString:string):integer;
var S1,S2:string;
        I:integer;
begin
  I:=pos(':',CommString);
  if I=0 then begin
                S1:=CommString;                                // contains only a port name
                S2:='38400'                                    // use default baud rate: 38400
              end
         else begin
                S1:=copy(CommString,1,I-1);                    // port name
                S2:=copy(CommString,I+1,length(CommString)-I); // baud rate
                try StrToInt(S2) except S2:='38400' end        // invalid rate -> use default
              end;

  with Form3 do
  begin
    Label2.Visible:=true;
    Label3.Visible:=true;
    if RefreshPortList(S1,S2) then begin                       // get list of valid ports
                                     Panel1.Visible:=true;
                                     Panel2.Visible:=false
                                   end
                              else begin
                                     Panel1.Visible:=false;
                                     Panel2.Visible:=true
//                                   ShowMessage('No Serial Ports Found')
                                   end;
    Edit1.Text:=HostString;
    Edit1.SelectAll;

    I:=ShowModal;                                              // pops up form

    if I=mrOk then if Panel1.Visible then begin
                                            CommString:=ComboBox1.Text+':'+ComboBox2.Text;
                                            if (ComboBox1.Text='') or
                                               (ComboBox2.Text='') then result:=0
                                                                   else result:=1
                                          end
                                     else begin
                                            HostString:=Edit1.Text;
                                            result:=2
                                          end
              else result:=0
  end
end;


function VerifyCommPort(CommString:string):boolean;
var S1,S2,S3:string;
           I:integer;
begin
  I:=pos(':', CommString);
  if I<>0 then begin
                 S1:=#10+copy(CommString,1,I-1)+#13;             // port name
                 S2:=copy(CommString,I+1,length(CommString)-I)   // baud rate
               end
          else begin
                 S1:=#10+CommString+#13;
                 S2:=''
               end;
  if (length(S1)<3) then result:=false else
  begin
    S3:=#10+FindPorts+#13;                         // list of available ports
    result:=(pos(uppercase(S1), uppercase(S3))<>0);
    if S2<>'' then try if StrToInt(S2)<1 then result:=false except result:=false end
  end
end;


procedure TForm3.FormShow(Sender: TObject);
begin
  Panel2.Left:=Panel1.Left;
  Form3.AutoSize:=true;
  if Panel1.Visible then Button1.SetFocus
                    else Edit1.SetFocus;
  Application.ProcessMessages
end;


// translate enter key within host edit box to OK
procedure TForm3.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if ord(Key)=VK_RETURN then ModalResult:=mrOk                 // map enter key
end;                                                           // to "OK" button


// gray 'network' label clicked - swap sides
procedure TForm3.Label2Click(Sender: TObject);
begin
  Panel2.Visible:=true;
  Panel1.Visible:=false;
  Edit1.SetFocus
end;


// gray 'serial' label clicked - swap sides
procedure TForm3.Label3Click(Sender: TObject);
begin
  if not RefreshPortList(ComboBox1.Text,ComboBox2.Text) then
  begin
    Form3.Visible:=false;
    ShowMessage('No Serial Ports Found');
    Form3.Visible:=true
  end else
  begin
    Panel1.Visible:=true;
    Panel2.Visible:=false;
    Button1.SetFocus
  end
end;


// refrech port list whenever list drops down
procedure TForm3.ComboBox1DropDown(Sender: TObject);
begin
  RefreshPortList(ComboBox1.Text,'_skip_')
end;


// globally, pressing escape cancels CONNECT dialog
procedure TForm3.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if ord(Key)=VK_ESCAPE then ModalResult:=mrCancel
end;



end.
